#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Inercia 2023 shader jamMod01.fsh   by   w23 
//https://www.shadertoy.com/view/DldfRs
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float t, tt;
const vec3 e=vec3(0.,1.,.001);
float ha(float f){return fract(sin(f)*26374.236);}
float ha(vec2 v){return ha(dot(v,vec2(17.5326,57.3224)));}
float no(vec2 v){vec2 V=floor(v);v-=V;v*=v*(3.-2.*v);
  return mix(
    mix(ha(V+e.xx), ha(V+e.xy), v.y),
    mix(ha(V+e.yx), ha(V+e.yy), v.y), v.x);
}
#define rm(a) mat2(cos(a),sin(a),-sin(a),cos(a))
float vmax(vec2 v){return max(v.x,v.y);}
#define box(p,s) vmax(abs(p)-(s))
#define PT(t,p) (floor(t)+pow(fract(t),p))
#define PTN(t,p) (floor(t)+1.-pow(1.-fract(t),p))

float h(vec2 p){
  //float ht=
  float d =
    sin(6.28*no(p)+PT(tt/4.,2.))*.4;
  d -= .5*no(p*.45-2.*e.yx*PTN(tt/2.,2.));
  return d;
}

float smin(float a,float b,float k){
  float h=max(0.,1.-abs(b-a)/k);
  return min(a,b)-h*h*k/4.;
}

float w(vec3 p) {
  float d = abs(p.y - h(p.xz)) - .02;
  d*=.5;
  //d = min(d, length(p)-1.);
  
  float sc=1.;
  vec2 C=floor(p.xz*sc),cc=fract(p.xz*sc)-.5;
  vec3 pc=vec3(cc,p.y).xzy;
  float r=.05+.2*ha(C);
  float pt=PT(tt,3.);
  pc.y-=.5-.3*sin(ha(C+.2)*6.283+pt*2.);
  pc.x+=.6*(ha(C+.3)-.5);
  pc.z+=.6*(ha(C+.4)-.5);
  d=smin(d,(length(pc)-r)*.3,.3);
  d=max(d,box(p.xz,4.));
  return d;
}
vec3 no(vec3 p){
  return normalize(w(p)-vec3(
    w(p-e.zxx),
    w(p-e.xzx),
    w(p-e.xxz)
  ));
}

float tr(vec3 ro,vec3 rd,float l,float L){
  for(float i=0.;i<200.;++i){
    float d=w(ro+rd*l);l+=d;
    if(d<l*.001||l>L)break;
  }
  return l;
}


// LOL COPYPASTE THANKS IQ!!11cos(0.)
vec3 palette( in float t, in vec3 a, in vec3 b, in vec3 c, in vec3 d )
{
    return a + b*cos( 6.28318*(c*t+d) );
}
vec3 pal(float t){
  return palette(t,
    vec3(.5),
    vec3(.5),
    vec3(2.,.8,.3),
    vec3(.5,.25,.2));
}

float ao(vec3 p,vec3 n,float N,float L){
  float k=0.;
  for (float i=0.;i<N;i++){
    float l=(i+1.)*L/N;
    float d=w(p+n*l)*3.;
    k+=step(l,d);
  }
  return k/N;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = (fragCoord/iResolution.xy-.5);
    uv.x *=iResolution.x/iResolution.y;
    t=iTime;
    tt=t*140./60.;

	//vec2 uv = vec2(gl_FragCoord.x / v2Resolution.x, gl_FragCoord.y / v2Resolution.y);
	//uv -= 0.5;
	//uv /= vec2(v2Resolution.y / v2Resolution.x, 1);
  
  vec3 C=vec3(0.),ro=vec3(0.,0.,10.),rd=normalize(vec3(uv,-1.5));
  mat2 X=rm(.5),Y=rm(.6+t*.2);
  rd.yz*=X;ro.yz*=X;
  rd.xz*=Y;ro.xz*=Y;
  float L=20.,l=tr(ro,rd,0.,L);
  
  if (l<L){
    vec3 p=ro+rd*l,n=no(p);
    vec3 sd=normalize(vec3(.3,.5,.1));
    float pp=floor(p.y*30./1.5)/30.;
    pp+=.2*ha(pp*3.);
    vec3 m=pal(pp);
    C=m*vec3(.03);//*ao(p,n,5.,1.);
    float sh=step(5.,tr(p,sd,.05,5.));
    C+=m*max(0.,dot(n,sd))*.7*sh;
    C+=m*pow(max(0.,dot(n,normalize(n+sd))), 150.)*.7*sh;
  }else{
    C=vec3(.6,.8,.9);
  }
  
  C*=smoothstep(1.,.5,length(uv));

	fragColor = vec4(sqrt(C),0.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

